<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;


class OrderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {

        return [
    'table_name' => 'orders',
    'id' => $this->order_id,
    'uuid' => $this->order_uniq_id,
    'title' =>  "From: " . $this->pickup_city . ', ' . $this->pickup_state . ', ' .$this->pickup_zip .  ' To: ' . $this->delivery_city . ', ' . $this->delivery_state . ', ' . $this->delivery_zip,
    'sub_title' => $this->shpr_name . ' ' . $this->shpr_email . ' ' . $this->shpr_mobile ,
    'status' =>  $this->status,
    'contact' => $this->shpr_name,
    'mobile' => $this->shpr_number,
    'email' =>  $this->shpr_email ,
    'load' =>   $this->car_year  . ' ' . $this->car_make . ' ' .  $this->car_model,
    'created' => $this->created,
    'source' => $this->source,
        ];

    }

}

//return  [
//    'id' => $this->order_uniq_id,
//    'received' => $this->received,
//    'quoted' => $this->quoted,
//    'created' => $this->created,
//    'first_avail' => $this->first_avail,
//    'car_run' => $this->car_run,
//    'ship_via' => $this->ship_via,
//    'shipper_notes' => $this->shipper_notes,
//    'assigned_to' => $this->assigned_to,
//    'shpr_name' => $this->shpr_name,
//    'shpr_number' => $this->shpr_number,
//    'shpr_scnd_number' => $this->shpr_scnd_number,
//    'shpr_company' => $this->shpr_company,
//    'shpr_company_phone' => $this->shpr_company_phone,
//    'shpr_mobile' => $this->shpr_mobile,
//    'shpr_fax' => $this->shpr_fax,
//    'shpr_address' => $this->shpr_address,
//    'shpr_scnd_address' => $this->shpr_scnd_address,
//    'shpr_state' => $this->shpr_state,
//    'shpr_city' => $this->shpr_city,
//    'shpr_zip' => $this->shpr_zip,
//    'shpr_country' => $this->shpr_country,
//    'shpr_email' => $this->shpr_email,
//    'car_year' => $this->car_year,
//    'car_make' => $this->car_make,
//    'car_model' => $this->car_model,
//    'car_type' => $this->car_type,
//    'car_color' => $this->car_color,
//    'car_plate_no' => $this->car_plate_no,
//    'car_state' => $this->car_state,
//    'car_vin' => $this->car_vin,
//    'car_lot_no' => $this->car_lot_no,
//    'car_additional_info' => $this->car_additional_info,
//    'car_condition' => $this->car_condition,
//    'origin_city' => $this->origin_city,
//    'origin_state' => $this->origin_state,
//    'origin_zip' => $this->origin_zip,
//    'origin_country' => $this->origin_country,
//    'dest_city' => $this->dest_city,
//    'dest_state' => $this->dest_state,
//    'dest_zip' => $this->dest_zip,
//    'dest_country' => $this->dest_country,
//    'origin' => $this->origin,
//    'destination' => $this->destination,
//    'vehicle' => $this->vehicle,
//    'no_vehicles' => $this->no_vehicles,
//    'tariff' => $this->tariff,
//    'deposit' => $this->deposit,
//    'total_quotes' => $this->total_quotes,
//    'total_deposit' => $this->total_deposit,
//    'tariff_markup' => $this->tariff_markup,
//    'pickup_add1' => $this->pickup_add1,
//    'pickup_add2' => $this->pickup_add2,
//    'pickup_city' => $this->pickup_city,
//    'pickup_state' => $this->pickup_state,
//    'pickup_zip' => $this->pickup_zip,
//    'pickup_country' => $this->pickup_country,
//    'pickup_cont_name' => $this->pickup_cont_name,
//    'pickup_comp_name' => $this->pickup_comp_name,
//    'pickup_buyer_number' => $this->pickup_buyer_number,
//    'pickup_phone_1' => $this->pickup_phone_1,
//    'pickup_phone_2' => $this->pickup,
//    'pickup_phone_2' => $this->pickup_phone_2,
//    'pickup_phone_3' => $this->pickup_phone_3,
//    'pickup_mobile' => $this->pickup_mobile,
//    'delivery_add1' => $this->delivery_add1,
//    'delivery_add2' => $this->delivery_add2,
//    'delivery_city' => $this->delivery_city,
//    'delivery_state' => $this->delivery_state,
//    'delivery_zip' => $this->delivery_zip,
//    'delivery_country' => $this->delivery_country,
//    'delivery_cont_name' => $this->delivery_cont_name,
//    'delivery_comp_name' => $this->delivery_comp_name,
//    'delivery_phone_1' => $this->delivery_phone_1,
//    'delivery_phone_2' => $this->delivery_phone_2,
//    'delivery_phone_3' => $this->delivery_phone_3,
//    'delivery_mobile' => $this->delivery_mobile,
//    'delivery_buyer_number' => $this->delivery_buyer_number,
//    'load_on' => $this->load_on,
//    'load_date' => $this->load_date,
//    'deliver_on' => $this->deliver_on,
//    'delivery_date' => $this->delivery_date,
//    'dispatch_contact' => $this->dispatch_contact,
//    'dispatch_phone' => $this->dispatch_phone,
//    'dispatch_fax' => $this->dispatch_fax,
//    'dispatch_email' => $this->dispatch_email,
//    'dispatched_to' => $this->dispatched_to,
//    'dispatched_to_info' => $this->dispatched_to_info,
//    'driver_firstname' => $this->driver_firstname,
//    'driver_lastname' => $this->driver_lastname,
//    'driver_phone' => $this->driver_phone,
//    'driver_email' => $this->driver_email,
//    'driver_response' => $this->driver_response,
//    'driver_response_date' => $this->driver_response_date,
//    'driver_order_status' => $this->driver_order_status,
//    'dispatch_sheet' => $this->dispatch_sheet,
//    'driver_signature' => $this->driver_signature,
//    'dispatch_instructions' => $this->dispatch_instructions,
//    'additional_info' => $this->additional_info,
//    'info_for_shipper' => $this->info_for_shipper,
//    'incl_shpr_cmnt' => $this->incl_shpr_cmnt,
//    'carrier_pay' => $this->carrier_pay,
//    'cod_cop_amount' => $this->cod_cop_amount,
//    'cop_cod_payment_method' => $this->cop_cod_payment_method,
//    'cop_cod_location' => $this->cop_cod_location,
//    'balance_amount' => $this->balance_amount,
//    'payment_terms' => $this->payment_terms,
//    'terms_begin' => $this->terms_begin,
//    'payment_method' => $this->payment_method,
//    'deposit_on' => $this->deposit_on,
//    'amount_deposited' => $this->amount_deposited,
//    'deposit_method' => $this->deposit_method,
//    'transaction_id' => $this->transaction_id,
//    'deposit_note' => $this->deposit_note,
//    'status' => $this->status,
//    'type' => $this->type,
//    'date_signed' => $this->date_signed,
//    'date_dispatched' => $this->date_dispatched,
//    'date_picked_up' => $this->date_picked_up,
//    'assumed_delivered' => $this->assumed_delivered,
//    'date_delivered' => $this->date_delivered
//];
