<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class QuoteResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
       return [

        'table_name' => 'quotes',
        'id' => $this->quote_id,
        'object_id' => $this->quote_uniq_id,
        'title' => "From: " . $this->origin_city . ', ' . $this->origin_state . ', ' .$this->origin_zip .  ' To: ' . $this->dest_city . ', ' . $this->dest_state . ', ' . $this->dest_zip,
        'sub_title' => $this->shpr_name . ' ' . $this->shpr_email . ' ' . $this->shpr_number,
        'status' => "Quote",
        'contact' => $this->shpr_name,
        'mobile' => $this->shpr_number,
        'email' => $this->shpr_email,
        'load' => $this->car_year  . ' ' . $this->car_make . ' ' .  $this->car_model,
        'created' => $this->quoted,
        'source' => $this->source,

       ];
    }
}
