<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class TaskResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {

        return [
        'table_name' => 'tasks',
        'id' => $this->task_id,
        'object_id' => $this->item_id,
        'item_id' => $this->item_id,
        'task_type' => $this->type,
        'type' => $this->type,
        'title' => strip_tags($this->todo),
        'sub_title' => "Due: " . $this->date,
        ];
    }
}
