<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Symfony\Component\HttpFoundation\Response;

class ApiVerificationMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {

        //get user details from header
        $api = $request->header('X-API-KEY');
        $userID = $request->header('USER-ID');

        if($api == '' || $userID == ''){
            return response()->json(['message' => 'Unauthorized.'], 401);
        }

        //get users company id, status and rights
        $user = DB::table('agents')->where('agent_id', $userID)->first();
        $companyId = $user->company_id;
        $user_status = $user->status;

        //get company api key
        $company = DB::table('accounts')->where('account_id',$companyId)->first();
        $company_api = $company->api_key;
        $account_status = $company->account_status;


        if ($company_api != $api || $user_status != 'active' || $account_status != 'active') {
//            return "failed";
            return response()->json(['message' => 'Unauthorized.'], 401);

        }
        //store the user in the session
        $request->session()->put('user', $user);

        return $next($request);
    }
}
