<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderCarResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
       return [
           'table_name' => 'orders',
           'id' => $this->order_id,
           'object_id' => $this->order_uniq_id,
           'title' => "From: " . $this->order_pickup_city . ', ' . $this->order_pickup_state . ', ' . $this->order_pickup_zip . ' To: ' . $this->order_delivery_city . ', ' . $this->order_delivery_state . ', ' . $this->order_delivery_zip,
           'sub_title' => $this->order_shpr_name . ' ' . $this->order_shpr_email . ' ' . $this->order_shpr_number,
           'status' => $this->order_status,
           'contact' => $this->order_shpr_name,
           'mobile' => $this->order_shpr_number,
           'email' => $this->order_shpr_email,
           'load' => $this->year . ' ' . $this->make . ' ' . $this->model,
           'created' => $this->order_created,
           'source' => $this->order_source
       ];
    }
}


//$row->table_name = 'orders';
//$row->id = $row->order_id;
//$row->object_id = $row->order_uniq_id;
//$row->title =  "From: " . $row->order_pickup_city . ', ' . $row->order_pickup_state . ', ' .$row->order_pickup_zip .  ' To: ' . $row->order_delivery_city . ', ' . $row->order_delivery_state . ', ' . $row->order_delivery_zip;
//$row->sub_title = $row->order_shpr_name . ' ' . $row->order_shpr_email . ' ' . $row->order_shpr_number ;
//$row->status =  $row->order_status;
//$row->contact = $row->order_shpr_name;
//$row->mobile = $row->order_shpr_number;
//$row->email =  $row->order_shpr_email ;
//$row->load =   $row->year  . ' ' . $row->make . ' ' .  $row->model;
//$row->created = $row->order_created;
//$row->source = $row->order_source;
