<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class QuoteCarResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
    return [
        'table_name' => 'quote_cars',
        'id' => $this->quote_car_id,
        'object_id' => $this->quote_id,
        'title' => "From: " . $this->origin_city . ', ' . $this->origin_state . ', ' . $this->origin_zip . ' To: ' . $this->dest_city . ', ' . $this->dest_state . ', ' . $this->dest_zip,
        'sub_title' => $this->shpr_name . ' ' . $this->shpr_email . ' ' . $this->shpr_number,
        'status' => 'Quote',
        'contact' => $this->shpr_name,
        'mobile' => $this->shpr_number,
        'email' => $this->shpr_email,
        'load' => $this->year . ' ' . $this->make . ' ' . $this->model,
        'created' => $this->created,
        'source' => $this->source
    ];

    }
}

//$row->table_name = 'quote_cars';
//$row->id = $row->quote_car_id;
//$row->object_id = $row->quote_id;
//$row->title =  "From: " . $row->origin_city . ', ' . $row->origin_state . ', ' .$row->origin_zip .  ' To: ' . $row->dest_city . ', ' . $row->dest_state . ', ' . $row->dest_zip;
//$row->sub_title = $row->shpr_name . ' ' . $row->shpr_email . ' ' . $row->shpr_number ;
//$row->status =  "Quote";
//$row->contact = $row->shpr_name;
//$row->mobile = $row->shpr_number;
//$row->email =  $row->shpr_email ;
//$row->load =   $row->year  . ' ' . $row->make . ' ' .  $row->model;
//$row->created = $row->created;
//$row->source = $row->source;
